  ' -----------------------------------------------------------
  ' Program for Micromite to communicate with the Elecrow RCWL0516
  ' microwave motion sensor module.
  ' Written by Jim Rowe for Silicon Chip.
  ' Last revision 7/8/2017 at 11:10 am
  ' ----------------------------------------------------------
  
  OPTION AUTORUN ON
  OPTION EXPLICIT
  
  DIM AS INTEGER MotSenFlag = 0      ' flag to show motion has been sensed
   
  Const DBlue = RGB(0,0,128)
  CONST Bone = RGB(255,255,192)
  CONST White = RGB(WHITE)
  CONST Black = RGB(BLACK)
  CONST Red = RGB(RED)
  CONST Green = RGB(GREEN)
  
  SETPIN 16, DIN          ' declare pin 16 an input (for module o/p)
    
  ' -----------------------------------------------------------------
  ' main program loop starts here
  CLS Black   ' now show opening screen on LCD
  RBOX 0,0, MM.HRes-2, MM.VRes-2, 5, RGB(Cyan), DBlue
  TEXT MM.HRes/2, MM.VRes/8, "SILICON CHIP", CM, 1, 3, Red, DBlue
  TEXT MM.HRes/2, MM.VRes/4, "RCWL-0516 movement", CM, 1, 2, White, DBlue
  TEXT MM.HRes/2, MM.VRes*3/8, "sense module tester", CM, 1, 2, White, DBlue
  RBOX 4, MM.VRes/2, MM.HRes-10, MM.VRes/2-6, 8, Black, Bone
  TEXT MM.HRes/2, MM.VRes*5/8, "NO MOTION", CM, 1,3, Black, Bone
  TEXT MM.HRes/2, MM.VRes*7/8, "DETECTED", CM, 1,3, Black, Bone
  DO
    IF PIN(16) = 1 THEN
      MotSenFlag = 1
      TEXT MM.HRes/2, MM.VRes*5/8, "  MOTION  ", CM, 1,3, Red, Bone
      TEXT MM.HRes/2, MM.VRes*7/8, "DETECTED", CM, 1,3, Red, Bone 
      PRINT "Movement detected: Output = HIGH" 
    PAUSE 5000         ' pause for 5 seconds, to digest     
    ELSE
      MotSenFlag = 0  ' but if pin 16 = 0, reset flag
      TEXT MM.HRes/2, MM.VRes*5/8, "NO MOTION", CM, 1,3, Black, Bone
      TEXT MM.HRes/2, MM.VRes*7/8, "DETECTED", CM, 1,3, Black, Bone
      PRINT "No movement detected: Output = LOW"
    END IF
    PAUSE 500   ' pause for looping about twice per second
  LOOP
END ' end of program
  
  ' ----------------------------------------------------------------
  
